<!--
/**
 *
 * K-onstruct CMS
 * Copyright (C) 2008-2011 Kevin Kis
 *
 * Formerly known as CECMS Content Management System
 *
 * PHP version 5
 * @copyright  2008-2011 Kevin Kis
 * @author     Kevin Kis <http://www.k-kombinat.de>
 *
 */

/******************************************************************************
 * VARS
 ******************************************************************************/
var quizthemeshort = "Milch mal anders";
var quiztheme = "Milch mal anders";
qarray = jQuery.parseJSON('{\n\
"q1": {\n\
        "res":"A", \n\
        "question"   :"Welche Tiere geben gewöhnlich Milch? ", \n\
        "selection_A":"Säugetiere",\n\
        "selection_B":"Vögel",\n\
        "selection_C":"Insekten",\n\
        "selection_D":"Reptilien",\n\
        "infoboxcontent":""\n\
},\n\
"q2": {\n\
        "res":"C", \n\
        "question"   :"Womit begannen die Menschen in der Steinzeit, als sie sesshaft wurden?", \n\
        "selection_A":"Sie lebten in Zelten, aßen Wurzeln und Kräuter und tranken aus Flüssen.",\n\
        "selection_B":"Sie lebten in Höhlen, jagten Tiere und sammelten Beeren und Pilze.",\n\
        "selection_C":"Sie bauten Hütten, legten Felder an und hielten sich Tiere.",\n\
        "selection_D":"Sie lebten auf Bäumen und aßen die Früchte und Nüsse. ",\n\
        "infoboxcontent":""\n\
},\n\
"q3": {\n\
        "res":"A", \n\
        "question"   :"In welchem der folgenden Lebensmittel ist keine Milch enthalten?", \n\
        "selection_A":"Margarine",\n\
        "selection_B":"Butter",\n\
        "selection_C":"Nuss-Nougat-Creme",\n\
        "selection_D":"Frischkäse",\n\
        "infoboxcontent":""\n\
},\n\
"q4": {\n\
        "res":"B", \n\
        "question"   :"Welche Beschwerden bekommen Menschen mit einer Milchzuckerunverträglichkeit, wenn sie Milchprodukte verzehren?", \n\
        "selection_A":"Kopfschmerzen",\n\
        "selection_B":"Bauchschmerzen",\n\
        "selection_C":"Atemprobleme",\n\
        "selection_D":"Halsschmerzen",\n\
        "infoboxcontent":""\n\
},\n\
"q5": {\n\
        "res":"C", \n\
        "question"   :"Welche Beschwerden können Menschen mit einer Milcheiweißallergie bekommen, wenn sie Milchprodukte verzehren?", \n\
        "selection_A":"Kopfschmerzen",\n\
        "selection_B":"Bauchmerzen",\n\
        "selection_C":"Atemprobleme",\n\
        "selection_D":"Halsschmerzen",\n\
        "infoboxcontent":""\n\
},\n\
"q6": {\n\
        "res":"C", \n\
        "question"   :"Auf welchem Kontinent kommt die Laktoseintoleranz (Milchzuckerunverträglichkeit) am häufigsten vor? ", \n\
        "selection_A":"Europa",\n\
        "selection_B":"Australien",\n\
        "selection_C":"Asien",\n\
        "selection_D":"Amerika",\n\
        "infoboxcontent":""\n\
},\n\
"q7": {\n\
        "res":"A", \n\
        "question"   :"Welchen Vorteil hatte die Entwicklung der Milchwirtschaft für die Menschen in Nordeuropa anfangs hauptsächlich?", \n\
        "selection_A":"Die Milch war bei schlechten Ernten und in harten Wintern verfügbar.",\n\
        "selection_B":"Die Milch konnte verkauft werden.",\n\
        "selection_C":"Die Milch schmeckte besser.",\n\
        "selection_D":"Keinen.",\n\
        "infoboxcontent":""\n\
},\n\
"q8": {\n\
        "res":"B", \n\
        "question"   :"Aus welchem Grund spielte tierische Milch in Südeuropa nie eine große Rolle?", \n\
        "selection_A":"Sie schmeckte den Menschen in Südeuropa nicht.",\n\
        "selection_B":"Sie wurde durch das warme Klima schnell schlecht.",\n\
        "selection_C":"In Südeuropa gab es zu wenig Kühe.",\n\
        "selection_D":"Es gibt keinen Grund dafür.",\n\
        "infoboxcontent":""\n\
},\n\
"q9": {\n\
        "res":"C", \n\
        "question"   :"Welche der folgenden Milchsorten ist eine echte Alternative für Menschen mit einer Milchallergie? ", \n\
        "selection_A":"Erdbeermilch ",\n\
        "selection_B":"Bananenmilch",\n\
        "selection_C":"Mandelmilch",\n\
        "selection_D":"Ziegenmilch",\n\
        "infoboxcontent":""\n\
},\n\
"q10":{\n\
        "res":"A", \n\
        "question"   :"Wofür ist das in Kuhmilch enthaltene Kalzium im menschlichen Körper gut?", \n\
        "selection_A":"Aufbau und Stabilität von Knochen und Zähnen",\n\
        "selection_B":"Besseres Wachstum der Haare",\n\
        "selection_C":"Verbesserung der Haut und Fingernägel",\n\
        "selection_D":"Verbesserung der Konzentrationsfähigkeit ",\n\
        "infoboxcontent":""\n\
}\n\
}');

resulttext = jQuery.parseJSON('{\n\
"8-10":"Applaus! Viel gewusst ohne Frust!", \n\
"5-7":"Nicht schlecht, aber es geht besser!", \n\
"0-4":"Das war wohl nichts! Noch einmal!"\n\
}');

/**
 * Template Bühnen ID's
 */
var resettscenes = Array(
    'leftsidequestions',
    'sidebar-questionpipes',
    'content-startselection',
    'content-questionboxes',
    'resultcontainer_1player',
    'resultcontainer_2player',
    'footer-selectionboxes'
    );
//ul-buttonbar

/**
 * Szenendefinitionen
 * hier werden container mit ids aufgezählt
 * !! hier dürfen keine leerzeichen in die aufzählung
 */
loadgamescene = jQuery.parseJSON('{\n\
"modiselection": {\n\
                     "show"       : "content-startselection", \n\
                     "hide"       : "", \n\
                     "activate"   : "", \n\
                     "deactivate" : "resolvebutton,checkbutton,storagebutton"  \n\
                  }, \n\
"oneplayer"       : {\n\
                     "show"       : "leftsidequestions,sidebar-questionpipes,content-questionboxes,footer-selectionboxes",\n\
                     "hide"       : "content-startselection", \n\
                     "activate"   : "resolvebutton,checkbutton,storagebutton", \n\
                     "deactivate" : "pipe_twoplayer,answeroption_twoplayer" \n\
                    }, \n\
"twoplayer": {\n\
                     "show"       : "leftsidequestions,sidebar-questionpipes,content-questionboxes,footer-selectionboxes",\n\
                     "hide"       : "content-startselection", \n\
                     "activate"   : "resolvebutton,checkbutton,storagebutton", \n\
                     "deactivate" : "" \n\
                    }, \n\
"oneplayer_result": {\n\
                     "show"       : "leftsidequestions,sidebar-questionpipes,resultcontainer_1player,footer-selectionboxes",\n\
                     "hide"       : "content-startselection", \n\
                     "activate"   : "", \n\
                     "deactivate" : "pipe_twoplayer,answeroption_twoplayer" \n\
                    }, \n\
"twoplayer_result": {\n\
                     "show"       : "leftsidequestions,sidebar-questionpipes,resultcontainer_2player,footer-selectionboxes",\n\
                     "hide"       : "content-startselection", \n\
                     "activate"   : "", \n\
                     "deactivate" : "" \n\
                    }\n\
}');


/**
 * Spielmodi
 * Optionen: oneplayer/twoplayer
 **/
var playermodi = "";
/**
 * Antworten Player 1Es gibt ein Kräfteungleichgewicht, weil eine Person vielen gegenübersteht.
 **/
var player1_selection = "";
/**
 * Antworten Player 2
 **/
var player2_selection = "";
/*
 * Aktuelle Frage
 */
var currentquestion = 0;
/**
 * Checkbuttonstatus
 * 1=Check / 2=Weiter / 2=Neuladen
 */
var checkbutton_status = 0;
/**
 * Spielstände
 **/
var score_player1 = 0;
var score_player2 = 0;
/*
 * Speichere die Antworten in einem Array um sie ggf im
 * localStorage zu speichern
 */
var answers_player1 = new Array();
var answers_player2 = new Array();
/*
 * Speichere der letzen Frage, die beantwortet wurde für Local Ttorage
 */
var lastquestion = 0;
/**
 * Anzahl der Fragen im Quiz
 * default 10
 */
var available_questions = 10 ;
/**
 * Delay mit dem Antortmöglichkeiten angezeigt und
 * Selectionbuttons aktiviert werden (in ms)
 * default 2800
 **/
var questdelay = 2800;



/******************************************************************************
 * LOS
 ******************************************************************************/

/**
 * Load on ready state
 */
$(function() {
    // Lade Startseite
    loadGameScene('modiselection');
    // Lade Fragen in Navigationsbox (noch nicht anzeigen)
    loadQuestionList();
    // Spieler-Modi Auswahl
    initStartSelectionHandler();
    // Initiiere Infoboxen
    loadInfoBoxes();
    // Zeige Alle Informationen bei Klick auf linke Seite !!! SB
    enableInfoBoxesWithAllInformation();
    // Initiiere Speicherbutton
    initLocalStorageEngine();
});


/******************************************************************************
 * ONLOAD FUNKTIONEN
 ******************************************************************************/

/**
 * Funktion zum An/Abschalten der verschiedenen SzeneLayer
 * modiselection/oneplayer/twoplayer/oneplayer_result/twoplayer_result
 **/
function loadGameScene(loadscene) {

    resetGameScene();

    for(key in loadgamescene) {

        var showscenes = loadgamescene[key].show.split(',');
        //var hidecenes = loadgamescene[key].hide.split(',');
        var activatecont = loadgamescene[key].activate.split(',');
        var deactivatecont = loadgamescene[key].deactivate.split(',');

        if(loadscene === key) {

            $.each(showscenes, function(index, sceneid) {
                $('#'+sceneid).show();
            });

            /*$.each(hidecenes, function(index, sceneid) {
        $('#'+sceneid).hide();
      });*/

            $.each(activatecont, function(index, sceneid) {
                $('#'+sceneid).removeClass('opacity_2');
            });

            $.each(deactivatecont, function(index, sceneid) {
                $('#'+sceneid).addClass('opacity_2');
            });
        }

    };
}

/**
 * Fragen auf linker Seite initiieren
 */
function loadQuestionList() {
    var i = 0;
    for(key in qarray)
    {
        i= i+1;
        var question = qarray[key].question;
        $('#mcs_container ol').append('<li class="navinfo inactive" rel="'+key+'"><span>'+question+'</span></li>');
    }
    setTimeout(function(){
        initNavScroll();
    },100);
}

/**
 * Funktion legt versteckte Container an mit den Infotexten zu den jeweiligen Fragen
 */
function loadInfoBoxes() {

    for(key in qarray) {

        var rightanswer = 'selection_'+qarray[key].res;
        var helptextfor = 'Infotext zu Frage '+key.substr(1);
        var correctanswer = qarray[key].question + '<br />' + '<span class="bold">'+qarray[key][rightanswer]+'</span>';
        var infoboxcontent = qarray[key].infoboxcontent;
        $('#MainBorder').append('<div class="infoborder" rel="'+key+'" style="display:none;"><div class="infobox_close"></div><h1>'+helptextfor+'</h1><h3 style="display:none;">'+correctanswer+'</h3><p>'+infoboxcontent+'</p></div>');
    }

    // focussierte infobox bekommt höchsten zindex
    $(".infoborder").click(function(){
        var sethigherzindex = highestZindex(".infoborder") + 1;
        $(this).css("z-index",sethigherzindex);
    });

    //set draggable
    $('.infoborder').draggable();

    //init close button
    $('.infobox_close').click(function(){
        $(this).parent().hide();
    })
}


/**
 * Startfunktion / Auswahl des Spielmodi und Speicherung in Variable /
 * Nach Auswahl Laden der Bühne
 * oneplayer/twoplayer
 */
function initStartSelectionHandler() {
    var modiselection_wrapper = $('#startSelection .startselection');

    modiselection_wrapper.click(function() {

        playermodi = ($(this).attr('id'));

        loadGameScene(playermodi);

        // Initiiere Frage 1
        activateQuestionNumberDependence(1);

        // Ändere LAden Button in Speichern Button
        switchLocalStorageButtons('save');

        // Aktiviere selection Buttons
        setTimeout(function(){
            initClickHandler_answers();
        },questdelay)

        initNavScroll();
    });

    // Header Thema laden
    $('#currentQuestion').html(quizthemeshort);
}

/**
 * Diese Funktion aktiviert alle zuständigen Module die bei einer Frage angezeigt werden sollen
 * Fragen linke Seite/ Fragen in der Pipe/ Fragen im Header/ Antwortmöglichkeiten in den
 * Boxen
 */
function activateQuestionNumberDependence(questionnumber, hidequestionboxes) {


    currentquestion = parseInt(questionnumber);

    // Übergebene Frage im linken Menü freischalten
    // ebenfalls den Zusatztext in den Infokästen freigeben
    $('#leftsidequestions .navinfo').each(function(){

        var qnumber = ($(this).attr('rel')).substr(1);

        if(qnumber <= questionnumber){
            $(this).removeClass('inactive');
        }
        if(qnumber < questionnumber) {
            $('.infoborder[rel="q'+qnumber+'"] h3').show();
        }
    })


    if(!hidequestionboxes){
        // Pipefragen einfärben
        if(playermodi == 'twoplayer') {
            $('#pipe_twoplayer_number_'+questionnumber).addClass('active');
        }
        $('#pipe_oneplayer_number_'+questionnumber).addClass('active');

        // Fragenummer im header anzeigen lassen
        $('#currentQuestionNumber span').html(currentquestion);

    }
    // Aktiviere die Infotextbox im Header SB!!!
    //enableInfoboxInHeader();

    $('#content-questionboxes').hide();

    // Fragen in header und boxen laden
    for(key in qarray) {
        if(key == 'q'+currentquestion){
            var rightanswer = qarray[key].res;
            var selection_A = qarray[key].selection_A;
            var selection_B = qarray[key].selection_B;
            var selection_C = qarray[key].selection_C;
            var selection_D = qarray[key].selection_D;
            var headerq = qarray[key].question;

            // Frage in Header laden
            $('#currentQuestion').removeClass('longtext');
		
            if(headerq.length > 45 && headerq.length < 88 ){
                $('#currentQuestion').addClass('longtext');
            }
			  if(headerq.length > 87 && headerq.length < 106){
                $('#currentQuestion').addClass('longlongtext');
            }
			 if(headerq.length > 105 ){
                $('#currentQuestion').addClass('longlonglongtext');
            }
			 if(headerq.length < 46 ){
                $('#currentQuestion').addClass('shorttext');
            }

            $('#currentQuestion').html(headerq);
            $('#qA .text').html(selection_A);
            $('#qB .text').html(selection_B);
            $('#qC .text').html(selection_C);
            $('#qD .text').html(selection_D);
        }
    }
    if(!hidequestionboxes){
        $('#content-questionboxes').delay(questdelay).fadeIn(800);
    }
}

/**
 * Funktion um Auswahl des Spielers einzufärben
 * und in Variable zu speichern
 * A/B/C/D
 */
function initClickHandler_answers() {

    // Bei Hover einfärben
    $('#quiZ .selectionbox .td').mouseenter(function(){
        $(this).addClass('hover')
    }).mouseleave(function(){
        $(this).removeClass('hover')
    })

    // Diesen Clickhandler nur laden wenn 2 Spieler ausgewählt wurden;
    if(playermodi == 'twoplayer') {
        $('#answeroption_twoplayer.selectionbox .td').click(function() {
            $('#answeroption_twoplayer.selectionbox .td').removeClass('active');
            $(this).addClass('active');
            player2_selection = $(this).children().text();
            setCheckButtonStatus('check');
        });
    }

    $('#answeroption_oneplayer.selectionbox .td').click(function() {
        $('#answeroption_oneplayer.selectionbox .td').removeClass('active');
        $(this).addClass('active');
        player1_selection = $(this).children().text();
        setCheckButtonStatus('check');
    });
}

/**
 * Clickhandler SelectionButtons entfernen
 **/
function unbindClickHandler_answers() {
    $('#answeroption_oneplayer.selectionbox .td').unbind('click');
    $('#answeroption_twoplayer.selectionbox .td').unbind('click');
}

/**
 * Funktion initiiert den Lösen Button Handler
 **/
function initClickHandler_resolve() {

    var x = Array('A','B','C','D');

    $('#resolvebutton').click(function() {

        for(key in qarray) {

            if(currentquestion == key.substr(1)) {

                var correctanswer = qarray[key].res;

                $.each(x, function(key, value) {

                    if(value==correctanswer){
                        $('#q'+value).addClass('correct');
                        $('#q'+value+' .qbox').addClass('correct');
                    }else {
                        $('#q'+value).addClass('wrong');
                        $('#q'+value+' .qbox').addClass('wrong');
                    }
                });
            }
        }
    });
}

/**
 * Clickhandler Resolve entfernen
 **/
function unbindClickHandler_resolve() {
    $('#resolvebutton').unbind('click');
}


/******************************************************************************
 * Check Button Handler
 ******************************************************************************/

/**
 * Button Check Funktion
 * checkbutton stati / 1= check / 2=weiter / 3=ergebnis /4=reload
 **/

function checK() {

    // Status 1: überprüfe Eingabe der Spieler, wenn freigegeben
    if(checkbutton_status == 1) {

        // Deaktiviere selection Buttons
        unbindClickHandler_answers();

        for(key in qarray) {

            if(currentquestion == key.substr(1)) {

                var rightanswer = qarray[key].res;

                // erhöhen des ScoreCounter und Einfärben der Container
                if(playermodi == 'twoplayer') {
                    if(player2_selection == rightanswer) {
                        setContainerColorByAnswer('player2', 'correct', rightanswer);
                        answers_player2.push(true);
                        score_player2 += 1;
                    }else {
                        setContainerColorByAnswer('player2','wrong', player2_selection);
                        answers_player2.push(false);
                    }
                }

                if(player1_selection == rightanswer) {
                    setContainerColorByAnswer('player1','correct', rightanswer);
                    answers_player1.push(true);
                    score_player1 += 1;
                } else {
                    setContainerColorByAnswer('player1','wrong', player1_selection);
                    answers_player1.push(false);
                }

                // Setze lastquestion für Storage Engine
                lastquestion += 1;

                // Buttonnamen und Status ändern
                setCheckButtonStatus('continue');

            }
        }

    // Status 2: Aktion nach Klick auf Weiter Button
    } else if(checkbutton_status == 2) {

        // Deaktiviere Lösen Button
        unbindClickHandler_resolve();

        // Antworteingaben zurücksetzen
        resetAnswer();

        // nächste Frage initiieren
        activateQuestionNumberDependence(currentquestion+1);

        // Aktiviere selection Buttons
        setTimeout(function(){
            initClickHandler_answers();
        },questdelay);

    // Status 3: Zeige Ergebnisse / Button in Neustart ändern
    } else if(checkbutton_status == 3) {

        // Antworteingaben zurücksetzen
        resetAnswer();

        if(playermodi == 'twoplayer') {
            loadGameScene('twoplayer_result');
        } else if (playermodi == 'oneplayer') {
            loadGameScene('oneplayer_result');
        }

        loadResult();

        // Checkbutton markieren und text reinladen
        $('#checkbutton').addClass('active');
        $('#checkbutton span').addClass('active').html('Neustart');
        $('#checkbutton').click(function(){
            location.reload();
        });
    }

}

/**
 * Button Bereitstellen / Einfärben und Status für check Funktion ändern
 * check / continue / ergebnis /reload
 **/
function setCheckButtonStatus(value) {

    // Button auf check setzen, wenn
    // Spieler Auswahl getroffen haben
    if (value == 'check') {
        var selection = false;

        if(playermodi == 'twoplayer') {
            if(player1_selection != "" && player2_selection != "") {
                selection = true;
            }
        } else {
            if(player1_selection != "") {
                selection = true;
            }
        }

        if(selection == true) {
            // Checkbutton markieren und text reinladen
            $('#checkbutton').addClass('active');
            $('#checkbutton span').addClass('active').html('Check');
            checkbutton_status = 1;
        }

    // Button für nächste Frage scharf machen oder Reload veranlassen
    } else if (value == 'continue') {

        // Aktiviere Lösen Button
        $('#resolvebutton').addClass('active');
        initClickHandler_resolve();

        // Aktiviere Weiter Button
        $('#checkbutton span').addClass('active').html('Weiter');

        if(currentquestion != available_questions) {
            checkbutton_status = 2;
        } else {
            checkbutton_status = 3;
        }

    }

}

/**
 * Setzen der Fragecontainerfarbe / PipeFarbe / und SelectionButton
 */
function setContainerColorByAnswer(player, value, selection) {

    // Einfärben Spieler 2
    if(player == 'player2') {

        if(value == 'correct') {
            $('#pipe_twoplayer_number_'+currentquestion).addClass('correct');
            $('#answeroption_twoplayer').find('.active').addClass('correct')
        } else if(value == 'wrong'){
            $('#pipe_twoplayer_number_'+currentquestion).addClass('wrong');
            $('#answeroption_twoplayer').find('.active').addClass('wrong')
        }

    // Einfärben Spieler 1
    }else if (player == 'player1') {

        if(value == 'correct') {
            $('#pipe_oneplayer_number_'+currentquestion).addClass('correct');
            $('#answeroption_oneplayer').find('.active').addClass('correct')
        } else if(value == 'wrong'){
            $('#pipe_oneplayer_number_'+currentquestion).addClass('wrong');
            $('#answeroption_oneplayer').find('.active').addClass('wrong')
        }
    }

    // Globales Einfärben der Container
    if(value == 'correct') {
        $('#q'+selection+'.qcontainer').addClass('correct');
        $('#q'+selection+' .qbox').addClass('correct');

    } else if(value == 'wrong'){
        $('#q'+selection+'.qcontainer').addClass('wrong');
        $('#q'+selection+' .qbox').addClass('wrong');

    }
}

/**
 * Setzen der Ergebniscontainerfarbe
 */
function setResultContainerColor() {

    var player1_resultbox = $('div[rel=resultbox_player1]');
    var player2_resultbox = $('div[rel=resultbox_player2]');

    if(score_player2 > score_player1) {
        player2_resultbox.css('border-color', '#2fd60a');
        player1_resultbox.css('border-color', '#c3182a');

    }else if(score_player2 < score_player1) {
        player2_resultbox.css('border-color', '#c3182a');
        player1_resultbox.css('border-color', '#2fd60a');

    }else if(score_player2 == score_player1){
        player2_resultbox.css('border-color', '#2fd60a');
        player1_resultbox.css('border-color', '#2fd60a');
    }

}


/******************************************************************************
 * Ergebnisse Laden
 ******************************************************************************/

/**
 * Funktion gibt Punktezahl und Text ans Frontend
 **/
function loadResult() {

    // Zeige Infobox mit allen Informationen bei letzter Frage !!! SB war auf true
    enableInfoBoxesWithAllInformation(false);

    // Header zurücksetzen
    $('#currentQuestionNumber span').html('X');

    if(quiztheme.length > 30){
        $('#currentQuestion').addClass('longlongtext');
    }
	 if(quiztheme.length < 31){
        $('#currentQuestion').addClass('shorttext');
    }
    $('#currentQuestion').html('Auswertung "'+quiztheme+'"');

    // Deaktiviere Speichern Button
    $('#storagebutton span').off('click');
    $('#storagebutton').addClass('opacity_2');

    //Deaktiviere bei Ergebnisanzeige die Infobox im Header
    $('#currentQuestion').off('click');

    if(playermodi == 'twoplayer') {
        setResultContainerColor();
        $('#endresult_twoplayer_player2').html(score_player2+' / '+available_questions);
        $('#endresult_twoplayer_player1').html(score_player1+' / '+available_questions);
        $('#endresulttext_twoplayer_player2').html(generateResultText(score_player2));
        $('#endresulttext_twoplayer_player1').html(generateResultText(score_player1));
    }else {
        $('#endresult_oneplayer').html(score_player1+' / '+available_questions);
        $('#endresulttext_oneplayer').html(generateResultText(score_player1));
    }

}

/**
 * Function generiert anhand der Punktezahl den Ergebnistext
 **/
function generateResultText(result) {

    for(resultscore in resulttext){

        if(result >=8 ) {
            return resulttext["8-10"];
        } else if(result >=5 ) {
            return resulttext["5-7"];
        } else  {
            return resulttext["0-4"];
        }

    }

}


/*******************************************************************************
 * Storage Handling
*******************************************************************************/

function initLocalStorageEngine() {

    var btn = $('#storagebutton span');

    if (localStorage.length == 0) {
        switchLocalStorageButtons("save");

    } else{
        switchLocalStorageButtons("load");
        $('#storagebutton').removeClass('opacity_2').addClass('active');

    }

    btn.click(function(){

        if(btn.html() == "Laden") {
            loadFromLocalStorage();
            switchLocalStorageButtons("save");

        } else {
            saveToLocalStorage();
            showMsgBox("Die aktuellen Eingaben wurden im Browser gespeichert. <br />Bei erneutem Spielen am Anfang auf „Laden“ klicken, um mit diesem Lösungsstand weiterzuarbeiten.");
        }

        initNavScroll();
    //enableInfoBoxesWithImages();
    });
}

function switchLocalStorageButtons(method) {

    var btn = $('#storagebutton span');

    // Schalte Buttton blau
    $('#storagebutton').removeClass('active');

    if(method == "save"){
        btn.html('Speichern')
    } else {
        btn.html('Laden')
    }
}

function loadFromLocalStorage() {

    answers_player1 = [localStorage['answers_player1']];
    answers_player2 = [localStorage['answers_player2']];
    score_player1 = parseInt ([localStorage['score_player1']]);
    score_player2 = parseInt ([localStorage['score_player2']]);
    // Erweiterung der aktuellen Frage um eins, da lastquestion schon gelöst wurde
    currentquestion = parseInt(localStorage['lastquestion']) + 1;
    lastquestion = parseInt(localStorage['lastquestion']);
    playermodi = localStorage['playermodi'];


    if(currentquestion > available_questions) {
        loadGameScene(localStorage['playermodi']+'_result');
        loadResult();
        activateQuestionNumberDependence(currentquestion,true);
    } else {
        loadGameScene(localStorage['playermodi']);
        activateQuestionNumberDependence(currentquestion);
    }

    // Aktiviere selection Buttons
    setTimeout(function(){
        initClickHandler_answers();
    },questdelay);

    // Lade Player1 Ergebnis in Pipe
    var player1result = localStorage['answers_player1'].split(',');
    $.each(player1result, function(index, value) {
        // wenn aktuelle frage,dann  markiere als blau
        if((index+1) == currentquestion) {
            $('#pipe_oneplayer_number_'+(index+1)).addClass('active');
        } else {
            if(value == 'true') {
                $('#pipe_oneplayer_number_'+(index+1)).addClass('correct');
            } else {
                $('#pipe_oneplayer_number_'+(index+1)).addClass('wrong');
            }
        }
    })
    // Lade Player2 Ergebnis in Pipe
    var player2result = localStorage['answers_player2'].split(',');
    $.each(player2result, function(index, value) {
        // wenn aktuelle frage,dann  markiere als blau
        if((index+1) == currentquestion) {
            $('#pipe_oneplayer_number_'+(index+1)).addClass('active');
        } else {
            if(value == 'true') {
                $('#pipe_twoplayer_number_'+(index+1)).addClass('correct');
            } else {
                $('#pipe_twoplayer_number_'+(index+1)).addClass('wrong');
            }
        }
    })
}

function saveToLocalStorage() {

    localStorage['playermodi'] = playermodi;
    localStorage['lastquestion'] = lastquestion;
    localStorage['answers_player1'] = answers_player1;
    localStorage['answers_player2'] = answers_player2;
    localStorage['score_player1'] = score_player1;
    localStorage['score_player2'] = score_player2;
}




/******************************************************************************
 * RESET FUNKTIONEN
 ******************************************************************************/

/**
 * Antwortfelder und Variablen zurücksetzen
 **/
function resetAnswer() {

    player1_selection = ""
    player2_selection = "";
    checkbutton_status = 0;

    $('#currentQuestion').removeClass('longtext');
    $('#resolvebutton').removeClass();
    $('#resolvebutton span').removeClass();
    $('#checkbutton').removeClass('active').removeClass('white');
    $('#checkbutton span').removeClass('active').html('Wähle');
    $('#question4Boxes .qcontainer').removeClass('correct').removeClass('wrong');
    $('#question4Boxes .qcontainer').removeClass('correct').removeClass('wrong');
    $('#question4Boxes .qbox').removeClass('correct').removeClass('wrong');
    $('#answeroption_oneplayer .td').removeClass('correct').removeClass('wrong').removeClass('active');
    $('#answeroption_twoplayer .td').removeClass('correct').removeClass('wrong').removeClass('active');
}

/**
 * Lösche alle Szenen
 */
function resetGameScene() {
    $.each(resettscenes, function(key, value) {
        $('#'+value).hide();
    });
}

/*
 * Lösche local storage
 */
function resetLocalStorage() {
    localStorage.clear();
}
/*
 * Lösche session storage
 */
function resetSesssionStorage() {
    sessionStorage.clear();
}


/******************************************************************************
 * INFOBOXES
 ******************************************************************************/

/**
 * Funktion, dass bei  Klick auf die Frage im Header die jeweilige
 * Infobox aufgeht
 */
 /**
function enableInfoboxInHeader() {
    // Fragen im Header
    $('#currentQuestion').click(function() {
        $('.infoborder[rel="q'+currentquestion+'"]').show();
    });
}
 */

function enableInfoBoxesWithAllInformation(showresult) {

    $('.navinfo').click(function(){

        var sethigherzindex = highestZindex(".infoborder") + 1;
        var wwidth = ($( window ).width() / 2) - 300;;
        var wheight = $( window ).height();

        var startleftbfposition = wwidth > 0 ? wwidth : 150;
        var starttopbfposition = wheight / 6.5;

        var relvalue = $(this).attr('rel');

        if(showresult) {
            $('.infoborder[rel="q'+available_questions+'"] h3').show();
        }

        $('.infoborder[rel="'+relvalue+'"]').css({
            "left": startleftbfposition,
            "top": starttopbfposition,
            "z-index": sethigherzindex
        }).show();


    })
}


function enableInfoboxInHeader_unbind() {
    $('#currentQuestion').unbind('click');
}

function hideInfoBoxes() {
    $('.infoborder').hide();
}
